 /* 'mrSurface.cpp' */

 /*  Komplementarny plik nagwka*/
#include "mrSurface.h"

 /* Konstruktor domylny */
mrSurface::mrSurface (void)
{
 m_pkD3DSurface = NULL;
 m_pkRawImage   = NULL;
}

 /* Destruktor domylny */
mrSurface::~mrSurface (void)
{
 if (m_pkD3DSurface != NULL)
 {
  m_pkD3DSurface->Release ();
  m_pkD3DSurface = NULL;
 }
 if (m_pkRawImage != NULL)
 {
  delete m_pkRawImage;
  m_pkRawImage   = NULL;
 }
}

 /* Tworzy powierchni */
mrError32 mrSurface::Create (mrRGBAImage * pkRawImage)
{
  /* Ustawia obraz rdowy powierzchni i aktualizuje powierzchni Direct3D */
 SetRawImage (pkRawImage);

 return Update ();
}

 /* Aktualizuje powierzchni Direct3D */
mrError32 mrSurface::Update (void)
{
 if (m_pkD3DSurface != NULL)
 {
  m_pkD3DSurface->Release ();
		m_pkD3DSurface = NULL;
 }

 if (m_pkRawImage == NULL)
 {
  return mrErrorInvalidRawImage;
 }
 
  /* Tworzy powierzchni */
 if (FAILED(mrScreen::GetSingleton ()->GetDevice ()->CreateImageSurface(
                  m_pkRawImage->GetWidth (),
                  m_pkRawImage->GetHeight (), 
                  (D3DFORMAT) mrScreen::GetSingleton ()->GetFormat (),
                  &m_pkD3DSurface ) ) )

 {
  m_pkD3DSurface = NULL;
  return mrErrorCreateImageSurface;
 }

  /* Blokuje powierchni */
 D3DLOCKED_RECT kLockedRect;
 m_pkD3DSurface->LockRect (&kLockedRect, NULL, 0);

  /* Wskaniki od zablokowanej powierzchni */
 WORD * pi16SurfaceBuffer;
 DWORD * pi32SurfaceBuffer;

  /* Uzyj odpowiedniego wskanika w zalenoci od gbi */
 if (mrScreen::GetSingleton ()->GetBitdepth () == 16)
 {
   /* Rzutuj wskanik aby wskazywa pierwszy piksel */
  pi16SurfaceBuffer = (WORD *) kLockedRect.pBits;
 }
 else 
 {
   /* Rzutuj wskanik aby wskazywa pierwszy piksel */
  pi32SurfaceBuffer = (DWORD *) kLockedRect.pBits;
 }

  /* Wypenij powierzchnie */
 mrUInt32 iX, iY;
 mrUInt32 iDepth;

  /* Pobierz gboko w bajtach i oblicz skok */
 iDepth = mrScreen::GetSingleton ()->GetBitdepth () / 8;
 mrUInt32 iPitch = kLockedRect.Pitch / iDepth;

 mrUInt8  iRed, iGreen, iBlue, iAlpha;
 mrUInt32 iColor;

 for (iY=0; iY < m_pkRawImage->GetHeight (); iY++)
 {
  for (iX=0; iX < m_pkRawImage->GetWidth (); iX++)
  {
    /* Pobierz komponenty koloru */
   iColor = m_pkRawImage->GetColor (iX, iY);

   iRed   = (mrUInt8)((iColor & 0xFF000000) >> 24);
   iGreen = (mrUInt8)((iColor & 0x00FF0000) >> 16);
   iBlue  = (mrUInt8)((iColor & 0x0000FF00) >> 8);
   iAlpha = (mrUInt8)((iColor & 0x000000FF));
 
    /* Zapisz kolor do bufora powierzchni zgodnie z trybem */
   if (mrScreen::GetSingleton ()->GetBitdepth () == 16)
   {
    if (mrScreen::GetSingleton ()->GetFormat () == D3DFMT_R5G6B5)
    {
     pi16SurfaceBuffer [iX + iY * iPitch] = 
              (mrUInt16)( (iRed   * ((1 << 5)-1) / 255 << 11) | 
                  (iGreen * ((1 << 6)-1) / 255  << 5) | 
                  (iBlue  * ((1 << 5)-1) / 255 ));
    }
    if (mrScreen::GetSingleton ()->GetFormat () == D3DFMT_X1R5G5B5)
    {
     pi16SurfaceBuffer [iX + iY * iPitch] = 
      (mrUInt16)((iRed   * ((1 << 5)-1) / 255  << 10) |
                  (iGreen * ((1 << 5)-1) / 255  << 5) |
                  (iBlue  * ((1 << 5)-1) / 255 ));
    }
    if (mrScreen::GetSingleton ()->GetFormat () == D3DFMT_A1R5G5B5)
    {
     pi16SurfaceBuffer [iX + iY * iPitch] = 
      (mrUInt16)(((iAlpha > 0) ? 1 : 0 << 15) |
                  (iRed   * ((1 << 5)-1) / 255  << 10) |
                  (iGreen * ((1 << 5)-1) / 255  << 5) |
                  (iBlue  * ((1 << 5)-1) / 255 ));
    }
   }
   else
   {
    pi32SurfaceBuffer [iX + iY * iPitch] = 
     D3DCOLOR_ARGB (iAlpha, iRed, iGreen, iBlue);
   }
  }
 }
  
  /* Odblokuj */
 m_pkD3DSurface->UnlockRect ();

 return mrNoError;
}

 /* Narysuj powierchni */
mrError32 mrSurface::Render (POINT * pkDestPoint, RECT * pkSourceRect)
{
  /* Pobierz bufor tylny */
 if (m_pkD3DSurface != NULL)
 {
  LPDIRECT3DSURFACE8 pBackBuffer;
  mrScreen::GetSingleton ()->GetDevice ()->GetBackBuffer (
                                            0, D3DBACKBUFFER_TYPE_MONO,
                                            &pBackBuffer);
   /* Skopiuj powierzchni na ekran */
  if (pkSourceRect != NULL)
  {
   mrScreen::GetSingleton ()->GetDevice ()->CopyRects (m_pkD3DSurface, pkSourceRect, 1,
                                         pBackBuffer, pkDestPoint);
  }
  else
  {
   RECT kImageRect;
    /* Uyj caego obrazu */
   kImageRect.left   = 0;
   kImageRect.top    = 0;
   kImageRect.right  = m_pkRawImage->GetWidth () - 1;
   kImageRect.bottom = m_pkRawImage->GetHeight () - 1;

   mrScreen::GetSingleton ()->GetDevice ()->CopyRects (m_pkD3DSurface, &kImageRect, 1,
                                         pBackBuffer, pkDestPoint);
  }
   /* Uwolnij bufor tylny */
  pBackBuffer->Release ();
 }
 return mrNoError;
}

 /* Ustaw obraz rdowy powierzchni */
void mrSurface::SetRawImage (mrRGBAImage * pkRawImage)
{
 if (m_pkRawImage == NULL)
 {
  m_pkRawImage = new mrRGBAImage ();
 }

 m_pkRawImage->SetWidth (pkRawImage->GetWidth ());
 m_pkRawImage->SetHeight (pkRawImage->GetHeight ());
 m_pkRawImage->SetImageBuffer (pkRawImage->GetImageBuffer ());
}

 /* Zwraca nowy obraz rdowy powierzchni */
mrRGBAImage * mrSurface::GetRawImage (void)
{
 return m_pkRawImage;
}
